"use strict";
exports.id = 2064;
exports.ids = [2064];
exports.modules = {

/***/ 2064:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "r": () => (/* binding */ getLayoutData)
/* harmony export */ });
/* harmony import */ var _http__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4550);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_http__WEBPACK_IMPORTED_MODULE_0__]);
_http__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];

let cachedLayoutData = null;
let cacheTimestamp = null;
const CACHE_DURATION = 60 * 60 * 1000 // 1 hour cache
;
async function getLayoutData(forceRefresh = false) {
    const now = Date.now();
    // Return cached data immediately if available and not expired
    if (!forceRefresh && cachedLayoutData && cacheTimestamp && now - cacheTimestamp < CACHE_DURATION) {
        return cachedLayoutData;
    }
    try {
        const navigation = await _http__WEBPACK_IMPORTED_MODULE_0__/* ["default"].get */ .Z.get("/admin/layouts");
        const layouts = navigation.data;
        const mainMenuObj = layouts.find((layout)=>layout.type === "main-menu");
        const mainMenuBtnObj = layouts.find((layout)=>layout.type === "main-menu-button");
        const topMenuObj = layouts.find((layout)=>layout.type === "top-menu");
        const bottomMenuObj = layouts.find((layout)=>layout.type === "bottom-menu");
        const footerObj = layouts.find((layout)=>layout.type === "footer");
        const globalTagsObj = layouts.find((layout)=>layout.type === "global-tags");
        const mobileLayoutObj = layouts.find((layout)=>layout.type === "mobile-layout");
        const mainMenu = JSON.parse(mainMenuObj?.menus || "[]");
        const mainMenuBtn = JSON.parse(mainMenuBtnObj?.menus || "[]");
        const topMenu = JSON.parse(topMenuObj?.menus || "[]");
        const bottomMenu = JSON.parse(bottomMenuObj?.menus || "[]");
        const mobileLayout = JSON.parse(mobileLayoutObj?.menus || "{}");
        const mobileTopMenu = topMenu.filter((menu)=>mobileLayout.top?.includes(menu.id));
        const restMobileTopMenu = topMenu.filter((menu)=>!mobileLayout.top?.includes(menu.id));
        const mobileMainMenu = [
            ...mainMenu,
            ...restMobileTopMenu
        ];
        const filteredMobileMainMenu = mobileMainMenu.filter((item)=>!item.url?.includes("/emergency-room-appointment"));
        cachedLayoutData = {
            mainMenu,
            mainMenuBtn,
            mobileMainMenu: filteredMobileMainMenu,
            topMenu,
            mobileTopMenu,
            bottomMenu,
            footer: footerObj || {},
            globalTags: globalTagsObj || {},
            mobileLayout
        };
        cacheTimestamp = now;
        return cachedLayoutData;
    } catch (error) {
        console.error("Error fetching layouts:", error);
        if (cachedLayoutData) {
            return cachedLayoutData;
        }
        return {
            mainMenu: [],
            mainMenuBtn: [],
            mobileMainMenu: [],
            topMenu: [],
            mobileTopMenu: [],
            bottomMenu: [],
            footer: {},
            globalTags: {},
            mobileLayout: {}
        };
    }
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 4550:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(9648);
/* harmony import */ var https__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5687);
/* harmony import */ var https__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(https__WEBPACK_IMPORTED_MODULE_1__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([axios__WEBPACK_IMPORTED_MODULE_0__]);
axios__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


// Create HTTPS agent with connection pooling
const httpsAgent = new (https__WEBPACK_IMPORTED_MODULE_1___default().Agent)({
    keepAlive: true,
    keepAliveMsecs: 3000,
    maxSockets: 50,
    maxFreeSockets: 10,
    timeout: 60000
});
const http = axios__WEBPACK_IMPORTED_MODULE_0__["default"].create({
    baseURL: "https://backend.ercare24.com/api",
    headers: {
        "X-Requested-With": "XMLHttpRequest",
        "Content-type": "application/json"
    },
    timeout: 10000,
    httpsAgent: httpsAgent,
    withCredentials: true
});
// Add response interceptor for error handling
http.interceptors.response.use((response)=>response, (error)=>{
    if (error.code === "ECONNABORTED") {
        console.error("Request timeout:", error.config.url);
    }
    return Promise.reject(error);
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (http);

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;