"use strict";
exports.id = 2513;
exports.ids = [2513];
exports.modules = {

/***/ 2165:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Map)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(358);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _react_google_maps_api__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2433);
/* harmony import */ var _react_google_maps_api__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_react_google_maps_api__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_icons_fa__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(6290);
/* harmony import */ var react_icons_fa__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_icons_fa__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(5941);
/* harmony import */ var _utils_http__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(4550);
/* harmony import */ var _utils_laravel_url__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(5101);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([swr__WEBPACK_IMPORTED_MODULE_6__, _utils_http__WEBPACK_IMPORTED_MODULE_7__]);
([swr__WEBPACK_IMPORTED_MODULE_6__, _utils_http__WEBPACK_IMPORTED_MODULE_7__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);









const fetcher = async (url)=>{
    const res = await _utils_http__WEBPACK_IMPORTED_MODULE_7__/* ["default"].get */ .Z.get(url);
    const data = await res.data;
    return data;
};
const containerStyle = {
    width: "100%",
    height: "450px"
};
function Map() {
    const [locations, setLocations] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)();
    const [closeLocation, setCloseLocation] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)();
    const [filterMap, setFilterMap] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
    const [focus] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)({
        lat: 31.0,
        lng: -100.0
    });
    const [userLocation, setUserLocation] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)();
    const [directionsResponse, setDirectionsResponse] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
    const [distance, setDistance] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)("");
    const [duration, setDuration] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)("");
    const [searchBox, setSearchBox] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
    const [libraries] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)([
        "places"
    ]);
    const originRef = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)();
    const [cardData, setCardData] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)();
    const [show, setShow] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const { data , error  } = (0,swr__WEBPACK_IMPORTED_MODULE_6__["default"])("/admin/locations", fetcher);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        if (data) {
            const dataList = data.filter((location)=>location.name !== "Greater Texas Division");
            setLocations(dataList);
            setFilterMap(dataList);
        }
        if ("geolocation" in navigator) {
            navigator.geolocation.getCurrentPosition(function(position) {
                setUserLocation({
                    lat: position.coords.latitude,
                    lng: position.coords.longitude
                });
            });
        } else {
            ;
        }
    }, [
        data
    ]);
    const hoverMarker = (location)=>{
        setCardData(location);
        setShow(true);
    };
    const unhoverMarker = ()=>{
        setShow(false);
    };
    const { isLoaded  } = (0,_react_google_maps_api__WEBPACK_IMPORTED_MODULE_3__.useLoadScript)({
        id: "google-map-script",
        googleMapsApiKey: "AIzaSyCT4mny4UpX93aIrK9HX92pGsYporZ-HZA",
        libraries
    });
    const deg2Rad = (deg)=>{
        return deg * Math.PI / 180;
    };
    const pythagorasEquirectangular = (lat1, lon1, lat2, lon2)=>{
        lat1 = deg2Rad(lat1);
        lat2 = deg2Rad(lat2);
        lon1 = deg2Rad(lon1);
        lon2 = deg2Rad(lon2);
        const R = 6371;
        const x = (lon2 - lon1) * Math.cos((lat1 + lat2) / 2);
        const y = lat2 - lat1;
        const d = Math.sqrt(x * x + y * y) * R;
        return d;
    };
    const closestEmergencyRoom = async (latitude, longitude)=>{
        let mindif = 99999;
        let closest;
        if (originRef.current.value === "") {
            latitude = userLocation.lat;
            longitude = userLocation.lng;
        }
        for(let index = 0; index < locations.length; ++index){
            const dif = pythagorasEquirectangular(latitude, longitude, locations[index].latitude, locations[index].longitude);
            if (dif < mindif) {
                closest = index;
                mindif = dif;
            }
        }
        setCloseLocation(locations[closest]);
        const directionService = new window.google.maps.DirectionsService();
        const results = await directionService.route({
            origin: originRef.current.value ? originRef.current.value : userLocation,
            destination: {
                lat: locations[closest].latitude,
                lng: locations[closest].longitude
            },
            travelMode: window.google.maps.TravelMode.DRIVING
        });
        setDirectionsResponse(results);
        setDistance(results.routes[0].legs[0].distance.text);
        setDuration(results.routes[0].legs[0].duration.text);
    };
    const onLoad = (autocomplete)=>{
        setSearchBox(autocomplete);
    // console.log(autocomplete)
    };
    const onPlacesChanged = ()=>{
        if (searchBox.getPlace()) {
            let latitude = searchBox.getPlace().geometry.location.lat();
            let longitude = searchBox.getPlace().geometry.location.lng();
            closestEmergencyRoom(latitude, longitude);
        } else {
            ;
        }
    };
    if (error) return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
        children: "Failed to load"
    });
    if (!data) return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
            className: "d-flex justify-content-center",
            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "spinner-grow text-danger",
                role: "status",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "visually-hidden",
                    children: "Loading..."
                })
            })
        })
    });
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
        children: [
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("section", {
                children: isLoaded ? /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__.Form.Label, {
                            children: "Enter your postal code, city and / or state"
                        }),
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_react_google_maps_api__WEBPACK_IMPORTED_MODULE_3__.Autocomplete, {
                            onLoad: onLoad,
                            onPlaceChanged: onPlacesChanged,
                            children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__.InputGroup, {
                                className: "mb-3",
                                size: "lg",
                                children: [
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__.Form.Control, {
                                        type: "text",
                                        className: "shadow-none",
                                        placeholder: "Search...",
                                        "aria-label": "Search...",
                                        "aria-describedby": "basic-addon2",
                                        // value={search || ''}
                                        // onChange={(e) => setSearch(e.target.value)}
                                        ref: originRef
                                    }),
                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__.Button, {
                                        id: "button-addon2",
                                        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_icons_fa__WEBPACK_IMPORTED_MODULE_4__.FaLocationArrow, {})
                                    })
                                ]
                            })
                        }),
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(_react_google_maps_api__WEBPACK_IMPORTED_MODULE_3__.GoogleMap, {
                            mapContainerStyle: containerStyle,
                            center: focus,
                            zoom: 6,
                            children: [
                                directionsResponse && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_react_google_maps_api__WEBPACK_IMPORTED_MODULE_3__.DirectionsRenderer, {
                                    directions: directionsResponse
                                }),
                                userLocation && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_react_google_maps_api__WEBPACK_IMPORTED_MODULE_3__.MarkerF, {
                                    label: "You are here!",
                                    position: userLocation
                                }),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_react_google_maps_api__WEBPACK_IMPORTED_MODULE_3__.MarkerF, {
                                    children: show && /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__.Card, {
                                        style: {
                                            width: "18rem"
                                        },
                                        children: [
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__.Card.Img, {
                                                variant: "top",
                                                src: _utils_laravel_url__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z + "/storage/" + cardData.img
                                            }),
                                            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__.Card.Body, {
                                                children: [
                                                    /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__.Card.Title, {
                                                        children: [
                                                            cardData.name,
                                                            " ",
                                                            cardData.status === 2 ? /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                                                className: "text-danger",
                                                                children: "(coming soon)"
                                                            }) : ""
                                                        ]
                                                    }),
                                                    /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__.Card.Text, {
                                                        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__.ListGroup, {
                                                            as: "ol",
                                                            variant: "flush",
                                                            children: [
                                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__.ListGroup.Item, {
                                                                    as: "li",
                                                                    children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                                                        className: "ms-2 me-auto",
                                                                        children: [
                                                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                                                                className: "fw-bold f-xs text-info",
                                                                                children: "Address"
                                                                            }),
                                                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("small", {
                                                                                children: cardData.address
                                                                            })
                                                                        ]
                                                                    })
                                                                }),
                                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__.ListGroup.Item, {
                                                                    as: "li",
                                                                    children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                                                        className: "ms-2 me-auto",
                                                                        children: [
                                                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                                                                className: "fw-bold text-info",
                                                                                children: "Phone"
                                                                            }),
                                                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("small", {
                                                                                children: cardData.tel
                                                                            })
                                                                        ]
                                                                    })
                                                                })
                                                            ]
                                                        })
                                                    })
                                                ]
                                            })
                                        ]
                                    })
                                }),
                                filterMap?.map((location, index)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_react_google_maps_api__WEBPACK_IMPORTED_MODULE_3__.MarkerF, {
                                        onMouseOver: ()=>hoverMarker(location),
                                        onMouseOut: unhoverMarker,
                                        position: {
                                            lat: location.latitude,
                                            lng: location.longitude
                                        },
                                        icon: {
                                            url: "/assets/signaturecare-mini.png",
                                            scaledSize: new google.maps.Size(25, 25)
                                        }
                                    }, index))
                            ]
                        })
                    ]
                }) : /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {})
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("br", {}),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("section", {
                children: closeLocation && /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                    children: [
                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h4", {
                            className: "mt-3",
                            children: "Directions to the Closest Emergency Room"
                        }),
                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("ul", {
                            className: "list-group list-group-numbered",
                            children: [
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("li", {
                                    className: "list-group-item d-flex justify-content-between align-items-start",
                                    children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                        className: "ms-2 me-auto",
                                        children: [
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                                className: "fw-bold",
                                                children: "Location Name: "
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                                className: "",
                                                children: closeLocation.name
                                            })
                                        ]
                                    })
                                }),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("li", {
                                    className: "list-group-item d-flex justify-content-between align-items-start",
                                    children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                        className: "ms-2 me-auto",
                                        children: [
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                                className: "fw-bold",
                                                children: "Address:"
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                                className: "",
                                                children: closeLocation.address
                                            })
                                        ]
                                    })
                                }),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("li", {
                                    className: "list-group-item d-flex justify-content-between align-items-start",
                                    children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                        className: "ms-2 me-auto",
                                        children: [
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                                className: "fw-bold",
                                                children: "Phone:"
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((next_link__WEBPACK_IMPORTED_MODULE_5___default()), {
                                                href: "tel:" + closeLocation.tel,
                                                className: "text-danger",
                                                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                                    children: closeLocation.tel
                                                })
                                            })
                                        ]
                                    })
                                }),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("li", {
                                    className: "list-group-item d-flex justify-content-between align-items-start",
                                    children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                        className: "ms-2 me-auto",
                                        children: [
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                                className: "fw-bold",
                                                children: "URL:"
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((next_link__WEBPACK_IMPORTED_MODULE_5___default()), {
                                                href: "/" + closeLocation.slug,
                                                className: "text-danger",
                                                children: "Go to location page"
                                            })
                                        ]
                                    })
                                }),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("li", {
                                    className: "list-group-item d-flex justify-content-between align-items-start",
                                    children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                        className: "ms-2 me-auto",
                                        children: [
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                                className: "fw-bold",
                                                children: "Distance:"
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                                className: "",
                                                children: distance
                                            })
                                        ]
                                    })
                                }),
                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("li", {
                                    className: "list-group-item d-flex justify-content-between align-items-start",
                                    children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                        className: "ms-2 me-auto",
                                        children: [
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                                className: "fw-bold",
                                                children: "Time:"
                                            }),
                                            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                                className: "",
                                                children: duration
                                            })
                                        ]
                                    })
                                })
                            ]
                        })
                    ]
                })
            })
        ]
    });
}

__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;