"use strict";
exports.id = 2695;
exports.ids = [2695];
exports.modules = {

/***/ 2695:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ MapHome)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(358);
/* harmony import */ var react_bootstrap__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _react_google_maps_api__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2433);
/* harmony import */ var _react_google_maps_api__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_react_google_maps_api__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _utils_laravel_url__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(5101);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var next_image__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(5675);
/* harmony import */ var next_image__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(next_image__WEBPACK_IMPORTED_MODULE_5__);







const containerStyle = {
    maxWidth: "100%",
    height: "600px",
    paddingTop: "0"
};
// ✅ Move libraries outside component to prevent re-renders
const libraries = [
    "places"
];
function MapHome({ locations =[]  }) {
    // ✅ Add libraries array to prevent re-loading
    const { isLoaded , loadError  } = (0,_react_google_maps_api__WEBPACK_IMPORTED_MODULE_3__.useLoadScript)({
        id: "google-map-script",
        googleMapsApiKey: "AIzaSyCT4mny4UpX93aIrK9HX92pGsYporZ-HZA",
        libraries
    });
    const [filterMap, setFilterMap] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)([]);
    const [cardData, setCardData] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
    const [show, setShow] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
    const [map, setMap] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
    const [initialBounds, setInitialBounds] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(null);
    const [mapHeight, setMapHeight] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(containerStyle.height);
    // ✅ Memoize filtered locations to prevent recalculation
    const filteredLocations = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(()=>{
        return locations?.filter((location)=>location.name !== "Greater Texas Division") || [];
    }, [
        locations
    ]);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        if (window.innerWidth < 768) {
            setMapHeight("400px");
        }
    }, []);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        if (filteredLocations.length > 0) {
            setFilterMap(filteredLocations);
        }
    }, [
        filteredLocations
    ]);
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(()=>{
        if (map && filterMap.length > 0 && isLoaded) {
            const bounds = new window.google.maps.LatLngBounds();
            filterMap.forEach((location)=>{
                if (location.latitude && location.longitude) {
                    bounds.extend(new window.google.maps.LatLng(location.latitude, location.longitude));
                }
            });
            setInitialBounds(bounds);
            const bottomPadding = window.innerWidth < 768 ? 0 : 100;
            map.fitBounds(bounds, {
                bottom: bottomPadding,
                left: 0,
                right: 0,
                top: 0
            });
        }
    }, [
        filterMap,
        isLoaded,
        map
    ]);
    // ✅ Use useCallback to prevent function recreation
    const onMapLoad = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((map)=>{
        setMap(map);
    }, []);
    const hoverMarker = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((location)=>{
        setCardData(location);
        setShow(true);
    }, []);
    const unhoverMarker = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(()=>{
        setShow(false);
        if (map && initialBounds) {
            map.fitBounds(initialBounds, {
                bottom: 100,
                left: 0,
                right: 0,
                top: 0
            });
        }
    }, [
        map,
        initialBounds
    ]);
    // ✅ Memoize map options to prevent re-renders
    const mapOptions = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(()=>({
            streetViewControl: false,
            zoomControlOptions: {
                position: isLoaded ? window.google.maps.ControlPosition.LEFT_TOP : 0
            }
        }), [
        isLoaded
    ]);
    // ✅ Handle load error
    if (loadError) {
        return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
            className: "d-flex justify-content-center align-items-center",
            style: {
                height: mapHeight
            },
            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
                className: "text-danger",
                children: "Error loading maps"
            })
        });
    }
    // ✅ Better loading state
    if (!isLoaded) {
        return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
            className: "d-flex justify-content-center align-items-center bg-light",
            style: {
                height: mapHeight
            },
            children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                className: "spinner-border text-primary",
                role: "status",
                children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                    className: "visually-hidden",
                    children: "Loading map..."
                })
            })
        });
    }
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
        "aria-label": "Interactive emergency room locations map",
        children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_react_google_maps_api__WEBPACK_IMPORTED_MODULE_3__.GoogleMap, {
            mapContainerStyle: {
                ...containerStyle,
                height: mapHeight
            },
            onLoad: onMapLoad,
            onClick: unhoverMarker,
            options: mapOptions,
            children: filterMap?.map((location, index)=>/*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_react_google_maps_api__WEBPACK_IMPORTED_MODULE_3__.MarkerF, {
                    onMouseOver: ()=>hoverMarker(location),
                    onClick: ()=>hoverMarker(location),
                    position: {
                        lat: parseFloat(location.latitude),
                        lng: parseFloat(location.longitude)
                    },
                    icon: {
                        url: "/assets/signaturecare-mini.webp",
                        scaledSize: isLoaded ? new google.maps.Size(25, 25) : undefined
                    },
                    children: show && cardData && cardData.name === location.name && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_react_google_maps_api__WEBPACK_IMPORTED_MODULE_3__.InfoWindowF, {
                        position: {
                            lat: parseFloat(cardData.latitude),
                            lng: parseFloat(cardData.longitude)
                        },
                        onCloseClick: unhoverMarker,
                        options: {
                            maxWidth: 300,
                            pixelOffset: new google.maps.Size(0, -10)
                        },
                        children: /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                            children: [
                                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__.Card, {
                                    className: "overflow-hidden d-none d-lg-block border-0",
                                    style: {
                                        width: "280px"
                                    },
                                    children: [
                                        cardData.img && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((next_image__WEBPACK_IMPORTED_MODULE_5___default()), {
                                            src: _utils_laravel_url__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z + "/storage/" + cardData.img,
                                            alt: cardData.name,
                                            width: 280,
                                            height: 160,
                                            sizes: "280px",
                                            quality: 80,
                                            className: "object-fit-cover"
                                        }),
                                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__.Card.Body, {
                                            className: "p-3",
                                            children: [
                                                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__.Card.Title, {
                                                    className: "fs-6 fw-bold mb-2",
                                                    children: [
                                                        cardData.name,
                                                        cardData.status === 2 && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                                            className: "badge bg-danger ms-2",
                                                            children: "coming soon"
                                                        })
                                                    ]
                                                }),
                                                /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                                    className: "d-grid gap-2 mb-3",
                                                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((next_link__WEBPACK_IMPORTED_MODULE_4___default()), {
                                                        href: cardData.google || "#",
                                                        className: "btn btn-danger btn-sm fw-bold",
                                                        target: "_blank",
                                                        rel: "noopener noreferrer",
                                                        children: "\uD83D\uDCCD Get Directions"
                                                    })
                                                }),
                                                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                                    className: "mb-2",
                                                    children: [
                                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                                            className: "text-muted small fw-bold mb-1",
                                                            children: "ADDRESS"
                                                        }),
                                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                                            className: "small fw-semibold",
                                                            children: cardData.address
                                                        })
                                                    ]
                                                }),
                                                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                                    children: [
                                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                                            className: "text-muted small fw-bold mb-1",
                                                            children: "PHONE"
                                                        }),
                                                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)((next_link__WEBPACK_IMPORTED_MODULE_4___default()), {
                                                            href: "tel:" + cardData.tel,
                                                            className: "text-danger text-decoration-none fw-bold small",
                                                            children: [
                                                                "\uD83D\uDCDE ",
                                                                cardData.tel
                                                            ]
                                                        })
                                                    ]
                                                })
                                            ]
                                        })
                                    ]
                                }),
                                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__.Card, {
                                    className: "overflow-hidden border-0 d-lg-none",
                                    style: {
                                        width: "260px"
                                    },
                                    children: [
                                        cardData.img && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((next_image__WEBPACK_IMPORTED_MODULE_5___default()), {
                                            src: _utils_laravel_url__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z + "/storage/" + cardData.img,
                                            alt: cardData.name,
                                            width: 260,
                                            height: 140,
                                            sizes: "260px",
                                            quality: 80,
                                            className: "object-fit-cover"
                                        }),
                                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__.Card.Body, {
                                            className: "p-2",
                                            children: [
                                                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_bootstrap__WEBPACK_IMPORTED_MODULE_2__.Card.Title, {
                                                    className: "fs-6 fw-bold mb-2",
                                                    children: [
                                                        cardData.name,
                                                        cardData.status === 2 && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
                                                            className: "badge bg-danger ms-1 small",
                                                            children: "coming soon"
                                                        })
                                                    ]
                                                }),
                                                /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                                                    className: "d-grid gap-1",
                                                    children: [
                                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx((next_link__WEBPACK_IMPORTED_MODULE_4___default()), {
                                                            href: cardData.google || "#",
                                                            className: "btn btn-danger btn-sm fw-bold",
                                                            target: "_blank",
                                                            rel: "noopener noreferrer",
                                                            children: "\uD83D\uDCCD Directions"
                                                        }),
                                                        /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                                                            className: "small fw-semibold text-muted",
                                                            children: cardData.address
                                                        }),
                                                        /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)((next_link__WEBPACK_IMPORTED_MODULE_4___default()), {
                                                            href: "tel:" + cardData.tel,
                                                            className: "btn btn-outline-danger btn-sm fw-bold",
                                                            children: [
                                                                "\uD83D\uDCDE ",
                                                                cardData.tel
                                                            ]
                                                        })
                                                    ]
                                                })
                                            ]
                                        })
                                    ]
                                })
                            ]
                        })
                    })
                }, location.id || index))
        })
    });
}


/***/ })

};
;