"use strict";
exports.id = 2977;
exports.ids = [2977];
exports.modules = {

/***/ 2977:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "$": () => (/* binding */ useLayout),
/* harmony export */   "a": () => (/* binding */ LayoutProvider)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


// Create context with default values
const LayoutContext = /*#__PURE__*/ (0,react__WEBPACK_IMPORTED_MODULE_1__.createContext)({
    mainMenu: [],
    mainMenuBtn: [],
    mobileMainMenu: [],
    topMenu: [],
    mobileTopMenu: [],
    bottomMenu: [],
    footer: {},
    globalTags: {},
    mobileLayout: {}
});
// Hook to use the layout context
const useLayout = ()=>{
    const context = (0,react__WEBPACK_IMPORTED_MODULE_1__.useContext)(LayoutContext);
    if (!context) {
        console.warn("useLayout must be used within LayoutProvider");
        return {
            mainMenu: [],
            mainMenuBtn: [],
            mobileMainMenu: [],
            topMenu: [],
            mobileTopMenu: [],
            bottomMenu: [],
            footer: {},
            globalTags: {},
            mobileLayout: {}
        };
    }
    return context;
};
// Provider component
const LayoutProvider = ({ children , layoutData  })=>{
    return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(LayoutContext.Provider, {
        value: layoutData,
        children: children
    });
};


/***/ })

};
;