"use strict";
exports.id = 3473;
exports.ids = [3473];
exports.modules = {

/***/ 3473:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ MainMenu)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(997);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(6689);
// EXTERNAL MODULE: ./node_modules/next/link.js
var next_link = __webpack_require__(1664);
var link_default = /*#__PURE__*/__webpack_require__.n(next_link);
// EXTERNAL MODULE: external "next/router"
var router_ = __webpack_require__(1853);
// EXTERNAL MODULE: external "react-icons/ti"
var ti_ = __webpack_require__(1946);
;// CONCATENATED MODULE: ./components/layouts/sub-menu.js





function Submenu({ submenus , id , count  }) {
    const [openDropdown, setOpenDropdown] = (0,external_react_.useState)(null);
    const router = (0,router_.useRouter)();
    const uri = router.asPath;
    count++;
    (0,external_react_.useEffect)(()=>{
        setOpenDropdown(null);
    }, [
        router
    ]);
    const handleDropdownToggle = (menuTitle)=>{
        setOpenDropdown(openDropdown === menuTitle ? null : menuTitle);
    };
    const activeMenu = (tree)=>{
        let result = JSON.stringify(tree).includes(uri + '"');
        return result;
    };
    return /*#__PURE__*/ jsx_runtime_.jsx(jsx_runtime_.Fragment, {
        children: /*#__PURE__*/ jsx_runtime_.jsx("ul", {
            className: "dropdown-menu m-0 p-0 border-0 rounded-0 shadow",
            "aria-labelledby": id,
            children: submenus?.map((submenu, index)=>/*#__PURE__*/ (0,jsx_runtime_.jsxs)("li", {
                    className: `dropdown-submenu d-md-flex border-bottom border-danger ${uri !== "/" && submenu.url === uri ? "active" : ""} ${uri !== "/" && activeMenu(submenu.submenu) ? "active" : ""}`,
                    children: [
                        /*#__PURE__*/ (0,jsx_runtime_.jsxs)((link_default()), {
                            href: submenu.url,
                            className: `dropdown-item nav-link text-white d-none d-lg-block ${submenu.url === "" ? "disabled text-dark" : ""} `,
                            children: [
                                /*#__PURE__*/ jsx_runtime_.jsx("span", {
                                    className: "d-md-none",
                                    children: count === 1 ? "- " : count === 2 ? "-- " : count === 3 ? "--- " : ""
                                }),
                                submenu.title
                            ]
                        }),
                        /*#__PURE__*/ (0,jsx_runtime_.jsxs)((link_default()), {
                            href: submenu.url,
                            className: `dropdown-item nav-link text-white d-lg-none d-inline-block w-75 ${submenu.url === "" ? "disabled text-dark" : ""} `,
                            children: [
                                /*#__PURE__*/ jsx_runtime_.jsx("span", {
                                    className: "d-md-none",
                                    children: count === 1 ? "- " : count === 2 ? "-- " : count === 3 ? "--- " : ""
                                }),
                                submenu.title
                            ]
                        }),
                        submenu.submenu.length > 0 ? /*#__PURE__*/ jsx_runtime_.jsx("a", {
                            className: "d-md-none d-inline-block nav-link px-2 me-2 float-end link-dark bg-danger",
                            id: submenu.title,
                            "data-bs-toggle": "dropdown",
                            "data-bs-auto-close": "outside",
                            onClick: ()=>handleDropdownToggle(submenu.title),
                            children: openDropdown === submenu.title ? /*#__PURE__*/ jsx_runtime_.jsx(ti_.TiMinus, {
                                className: "ti-minus-mobile float-end fw-bold"
                            }) : /*#__PURE__*/ jsx_runtime_.jsx(ti_.TiPlus, {
                                className: "ti-plus-mobile float-end fw-bold"
                            })
                        }) : "",
                        submenu.submenu.length > 0 ? /*#__PURE__*/ jsx_runtime_.jsx(Submenu, {
                            submenus: submenu.submenu,
                            id: submenu.title,
                            count: count
                        }) : ""
                    ]
                }, index))
        })
    });
}

// EXTERNAL MODULE: ./node_modules/next/image.js
var next_image = __webpack_require__(5675);
var image_default = /*#__PURE__*/__webpack_require__.n(next_image);
;// CONCATENATED MODULE: ./components/layouts/main-menu.js








function MainMenu({ menuItems =[] , mainMenuBtn ={}  }) {
    const router = (0,router_.useRouter)();
    const uri = router.asPath;
    const [openDropdown, setOpenDropdown] = (0,external_react_.useState)(null);
    const [collapsed, setCollapsed] = (0,external_react_.useState)(true);
    // Function to toggle navbar collapse state
    const toggleNavbar = ()=>{
        setCollapsed(!collapsed);
        ;
    };
    // Function to close the navbar
    const closeNavbar = ()=>{
        setOpenDropdown(null);
        setCollapsed(true);
    };
    (0,external_react_.useEffect)(()=>{
        closeNavbar();
    }, [
        router
    ]);
    const handleDropdownToggle = (menuTitle)=>{
        setOpenDropdown(openDropdown === menuTitle ? null : menuTitle);
    };
    const activeMenu = (tree)=>{
        let result = JSON.stringify(tree).includes(uri + '"');
        return result;
    };
    // Show loading state if data is not ready
    if (!menuItems || menuItems.length === 0) {
        return /*#__PURE__*/ jsx_runtime_.jsx("nav", {
            className: "navbar navbar-expand-lg navbar-light bg-white py-0 mb-3",
            children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                className: "container",
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                        className: "navbar-brand",
                        href: "/",
                        children: /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                            className: "navbar-brand",
                            href: "/",
                            prefetch: false,
                            children: /*#__PURE__*/ jsx_runtime_.jsx((image_default()), {
                                src: "/assets/SignatureCareER.png",
                                width: 240,
                                height: 45,
                                className: "d-inline-block align-top",
                                alt: "SignatureCare",
                                priority: true
                            })
                        })
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                        className: "ms-auto",
                        children: "Loading..."
                    })
                ]
            })
        });
    }
    return /*#__PURE__*/ jsx_runtime_.jsx(jsx_runtime_.Fragment, {
        children: /*#__PURE__*/ jsx_runtime_.jsx("nav", {
            className: "navbar navbar-expand-lg navbar-light bg-white py-0 mb-3",
            children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                className: "container",
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                        className: "navbar-brand",
                        href: "/",
                        children: /*#__PURE__*/ jsx_runtime_.jsx((image_default()), {
                            src: "/assets/SignatureCareER.png",
                            width: 240,
                            height: 45,
                            className: "d-inline-block align-top",
                            alt: "SignatureCare",
                            priority: true
                        })
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx("button", {
                        onClick: toggleNavbar,
                        className: "navbar-toggler",
                        type: "button",
                        "data-bs-toggle": "collapse",
                        "data-bs-target": "#navbarSupportedContent",
                        "aria-controls": "navbarSupportedContent",
                        "aria-expanded": !collapsed ? "true" : "false",
                        "aria-label": "Toggle navigation",
                        children: /*#__PURE__*/ jsx_runtime_.jsx("span", {
                            className: "navbar-toggler-icon"
                        })
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                        className: `collapse navbar-collapse ${collapsed ? "" : "show"}`,
                        id: "navbarSupportedContent",
                        children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("ul", {
                            className: "navbar-nav navbar-nav-customize ms-auto fw-bold",
                            children: [
                                mainMenuBtn?.url && /*#__PURE__*/ jsx_runtime_.jsx("li", {
                                    className: "nav-item d-flex align-items-center d-lg-none",
                                    children: /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                        href: mainMenuBtn.url,
                                        style: {
                                            backgroundColor: mainMenuBtn.background || "#0dcaf0",
                                            color: mainMenuBtn.color || "#fff"
                                        },
                                        className: "btn btn-info ms-3 py-2 text-sm fw-bolder text-white",
                                        children: mainMenuBtn.title || "Book Now"
                                    })
                                }),
                                menuItems.map((menu, index)=>/*#__PURE__*/ (0,jsx_runtime_.jsxs)("li", {
                                        className: `nav-item nav-item-customize dropdown ${uri !== "/" && activeMenu(menu.submenu || []) ? "active" : ""} ${uri === menu.url ? "active" : ""}`,
                                        children: [
                                            /*#__PURE__*/ (0,jsx_runtime_.jsxs)((link_default()), {
                                                href: menu.url || "#",
                                                className: `nav-link main-nav-link px-3 d-none d-lg-block d-inline-block ${!menu.url ? "disabled" : ""}`,
                                                children: [
                                                    menu.title,
                                                    " ",
                                                    menu.submenu?.length > 0 ? /*#__PURE__*/ jsx_runtime_.jsx(ti_.TiPlus, {
                                                        className: "ti-plus-desktop"
                                                    }) : ""
                                                ]
                                            }),
                                            /*#__PURE__*/ (0,jsx_runtime_.jsxs)((link_default()), {
                                                href: menu.url || "#",
                                                className: `nav-link main-nav-link px-3 d-lg-none d-inline-block py-1 w-75 ${!menu.url ? "disabled" : ""}`,
                                                children: [
                                                    menu.title,
                                                    " ",
                                                    menu.submenu?.length > 0 ? /*#__PURE__*/ jsx_runtime_.jsx(ti_.TiPlus, {
                                                        className: "ti-plus-desktop"
                                                    }) : ""
                                                ]
                                            }),
                                            menu.submenu?.length > 0 && /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                                className: "d-md-none d-inline-block nav-link px-2 me-2 float-end bg-danger",
                                                id: menu.title,
                                                "data-bs-toggle": "dropdown",
                                                "data-bs-auto-close": "outside",
                                                onClick: ()=>handleDropdownToggle(menu.title),
                                                children: openDropdown === menu.title ? /*#__PURE__*/ jsx_runtime_.jsx(ti_.TiMinus, {
                                                    className: "ti-minus-mobile float-end fw-bold"
                                                }) : /*#__PURE__*/ jsx_runtime_.jsx(ti_.TiPlus, {
                                                    className: "ti-plus-mobile float-end fw-bold"
                                                })
                                            }),
                                            menu.submenu?.length > 0 && /*#__PURE__*/ jsx_runtime_.jsx(Submenu, {
                                                submenus: menu.submenu,
                                                id: menu.title,
                                                count: 0
                                            })
                                        ]
                                    }, index)),
                                mainMenuBtn?.url && /*#__PURE__*/ jsx_runtime_.jsx("li", {
                                    className: "nav-item align-self-center d-none d-lg-block",
                                    children: /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                        href: mainMenuBtn.url,
                                        style: {
                                            backgroundColor: mainMenuBtn.background || "#0dcaf0",
                                            color: mainMenuBtn.color || "#fff"
                                        },
                                        className: "btn btn-info ms-3 py-3 text-sm fw-bolder",
                                        children: mainMenuBtn.title || "Book Now"
                                    })
                                })
                            ]
                        })
                    })
                ]
            })
        })
    });
}


/***/ })

};
;