import Image from 'next/image';
import Link from 'next/link';
import React from 'react';
import { Modal } from 'react-bootstrap';

export default function FacebookModal(props) {

    return (
        <>
            <Modal show={props.showFacebook} onHide={props.close} size='lg'>
                <Modal.Header closeButton>
                    <center><Image width="0" height="0" sizes="100vw" style={{ width: 'auto', height: 'auto' }} className='w-75 d-block' src='/assets/facebook-5-star.png' alt='' /></center>
                </Modal.Header>
                <Modal.Body>
                    <div className='row'>
                        <div className='col-md-8'>
                            <p>Facebook lets us stay connected with our customers, fans and friends—and now lets you review businesses.</p>
                            <p>From our Facebook page:</p>
                            <ul>
                                <li>Log in or sign up if you haven’t already</li>
                                <li>Find the <b>Recommendations</b> widget in the body of the page and recommend us</li>
                                <li>Leave additional feedback at the prompt</li>
                                <li>“Like” our page if you want to stay connected with us</li>
                            </ul>
                            <p><strong>Note:</strong> This website is not affiliated with or endorsed by Facebook.</p>
                        </div>
                        <div className='col-md-4 '>
                            <Image width="0" height="0" sizes="100vw" style={{ width: 'auto', height: 'auto' }} alt='facebook-signin' className='w-100 d-block mb-3' src='/assets/facebook-signin.png' />
                            <Image width="0" height="0" sizes="100vw" style={{ width: 'auto', height: 'auto' }} alt='facebook-review' className='w-100 d-block mb-3' src='/assets/facebook-review.png' />
                            <Image width="0" height="0" sizes="100vw" style={{ width: 'auto', height: 'auto' }} alt='facebook-like' className='w-100 d-block mb-3' src='/assets/facebook-like.png' />
                        </div>
                    </div>
                </Modal.Body>
                <Modal.Footer>
                    <Link href={props.facebookReview} className='btn btn-danger mx-auto' target='_blank' style={{ borderRadius: '20px' }}><strong>Review Us On Facebook</strong></Link>
                </Modal.Footer>
            </Modal>
        </>
    );
}
