import Image from 'next/image';
import Link from 'next/link';
import React from 'react';
import { Modal } from 'react-bootstrap';

export default function GoogleModal(props) {

    return (
        <>
            <Modal show={props.showGoogle} onHide={props.close}>
                <Modal.Header closeButton>
                    <center><Image  width="0" height="0" sizes="100vw" style={{ width: 'auto', height: 'auto' }} className='w-75 d-block' src='/assets/google-5-star.png' alt='google-5-star' /></center>
                </Modal.Header>
                <Modal.Body>
                    <div className='row'>
                        <div className='col-md-8'>
                            <p>If you don’t already have a Google account, you should—use it to read and post reviews, as well as access other Google products like Gmail.</p>
                            <p>From our Google listing:</p>
                            <ul>
                                <li>If prompted, <b>sign up</b> or <b>log in</b></li>
                                <li>Leave your <b>rating</b> and feedback</li>
                                <li>Click <strong>post</strong> to share with others.</li>
                            </ul>
                            <p><strong>Note:</strong> This website is not affiliated with or endorsed by Google.</p>
                        </div>
                        <div className='col-md-4 '>
                            <Image width="0" height="0" sizes="100vw" style={{ width: 'auto', height: 'auto' }} className='w-100 d-block mb-3' src='/assets/google-signin.png' alt='google-signin' />
                            <Image width="0" height="0" sizes="100vw" style={{ width: 'auto', height: 'auto' }} className='w-100 d-block mb-3' src='/assets/google-review.png' alt='google-review' />
                            <Image width="0" height="0" sizes="100vw" style={{ width: 'auto', height: 'auto' }} className='w-100 d-block mb-3' src='/assets/google-post.png' alt='google-post' />
                        </div>
                    </div>
                </Modal.Body>
                <Modal.Footer>
                    <Link href={props.googleReview} className='btn btn-danger mx-auto' target='_blank' rel="noreferrer" style={{ borderRadius: '20px' }}><strong>Review Us On Google</strong></Link>
                </Modal.Footer>
            </Modal>
        </>
    );
}
