import React, { useState } from 'react';
import { Modal } from 'react-bootstrap';
import { FcGoogle } from 'react-icons/fc';
import { FaFacebookSquare } from 'react-icons/fa';
import GoogleModal from './google-modal';
import FacebookModal from './facebook-modal';
import ContactModal from './contact-modal';

export default function LikeModal({ likeModalShow, close, google, facebook }) {
    const [showGoogle, setShowGoogle] = useState(false);
    const [showFacebook, setShowFacebook] = useState(false);
    const [contactModalShow, setContactModalShow] = useState(false);

    return (
        <>
            <GoogleModal showGoogle={showGoogle} close={() => setShowGoogle(false)} googleReview={google} />
            <FacebookModal showFacebook={showFacebook} close={() => setShowFacebook(false)} facebookReview={facebook} />
            <ContactModal contactModalShow={contactModalShow} close={() => setContactModalShow(false)} />

            <Modal show={likeModalShow} onHide={close}>
                <Modal.Header closeButton>
                    <h6 className='text-primary text-center'>Thank you! <b>We need your help.</b> Would you share your experience on one of these sites?</h6>
                </Modal.Header>
                <Modal.Body>
                    <center className='mb-5'>
                        <button className='btn btn-outline-primary m-2' style={{ borderRadius: '50px' }} onClick={() => setShowGoogle(true)}>
                            <div className='d-flex'>
                                <span><FcGoogle className='h1 mr-3' /></span>
                                <div>
                                    <span>CLICK HERE TO LEAVE A</span><br />
                                    <strong>GOOGLE REVIEW</strong>
                                </div>
                            </div>
                        </button>
                        <br />
                        <button className='btn btn-outline-primary m-2' style={{ borderRadius: '50px' }} onClick={() => setShowFacebook(true)}>
                            <div className='d-flex'>
                                <span><FaFacebookSquare className='h1 mr-3' /></span>
                                <div>
                                    <span>LEAVE A REVIEW ON</span><br />
                                    <strong>FACEBOOK</strong>
                                </div>
                            </div>
                        </button>
                    </center>
                </Modal.Body>
                {/* <Modal.Footer>
                    <p>If you have concerns you wish to address in private, please get in touch.</p>
                    <button
                        onClick={() => setContactModalShow(true)}
                        className='btn btn-info btn-block'>Contact US</button>
                </Modal.Footer> */}
            </Modal>
        </>
    );
}
