import { useEffect, useRef } from "react";
import Script from "next/script";

export default function GoogleTranslate() {
  const scriptLoaded = useRef(false);

  const googleTranslateElementInit = () => {
    if (window.google && window.google.translate) {
      new window.google.translate.TranslateElement(
        {
          pageLanguage: "en",
          layout: window.google.translate.TranslateElement.InlineLayout.SIMPLE,
          autoDisplay: true,
          includedLanguages: "en,es,ur,hi,ar,ml,vi,ig,yo",
        },
        "google_translate_element"
      );
    }
  };

  useEffect(() => {
    // Only initialize once
    if (!scriptLoaded.current) {
      window.googleTranslateElementInit = googleTranslateElementInit;
      scriptLoaded.current = true;
    }
  }, []);

  return (
    <>
      <div className="text-center">
        <div id="google_translate_element" className="translate"></div>
      </div>
      
      {/* Load Google Translate script lazily */}
      <Script
        src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"
        strategy="lazyOnload"
        onLoad={() => {
          console.log("Google Translate loaded");
        }}
      />
    </>
  );
}