import React from 'react'
import Link from 'next/link';

export default function BottomMenu({ menuItems }) {
    return (
        <>
            <section className='d-flex justify-content-center'>
                <small className='mb-5'>
                    <div className="d-flex flex-wrap justify-content-center">
                        {menuItems?.map((nav, index) => (
                            <div key={index} className="d-flex align-items-center text-dark">
                                <Link href={nav.url} className="px-2 py-2 fw-bold text-dark bottom-menu">{nav.title}</Link>
                                {index !== menuItems.length - 1 && <span className="">.</span>}
                            </div>
                        ))
                        }
                    </div>
                </small>
            </section>
        </>
    )
}
