import Link from 'next/link';
import { useRouter } from 'next/router';
import React, { useEffect, useState } from 'react'
import { TiPlus, TiMinus } from "react-icons/ti";

export default function Submenu({ submenus, id, count }) {
    const [openDropdown, setOpenDropdown] = useState(null);
    const router = useRouter();
    const uri = router.asPath;
    count++;

    useEffect(() => {
        setOpenDropdown(null);
    }, [router])

    const handleDropdownToggle = (menuTitle) => {
        setOpenDropdown(openDropdown === menuTitle ? null : menuTitle);
    };

    const activeMenu = (tree) => {
        let result = JSON.stringify(tree).includes(uri + '"');
        return result;
    }

    return (
        <>
            <ul className="dropdown-menu m-0 p-0 border-0 rounded-0 shadow" aria-labelledby={id}>
                {submenus?.map((submenu, index) => (
                    <li key={index} className={`dropdown-submenu d-md-flex border-bottom border-danger ${uri !== '/' && submenu.url === uri ? "active" : ""} ${uri !== '/' && activeMenu(submenu.submenu) ? 'active' : ''}`}>
                        {/* For Large Screen */}
                        <Link href={submenu.url} className={`dropdown-item nav-link text-white d-none d-lg-block ${submenu.url === '' ? 'disabled text-dark' : ''} `}>
                            <span className='d-md-none'>{count === 1 ? '- ' : (count === 2 ? '-- ' : (count === 3 ? '--- ' : ''))}</span>
                            {submenu.title}
                        </Link>
                        {/* For Mobile Screen */}
                        <Link href={submenu.url} className={`dropdown-item nav-link text-white d-lg-none d-inline-block w-75 ${submenu.url === '' ? 'disabled text-dark' : ''} `}>
                            <span className='d-md-none'>{count === 1 ? '- ' : (count === 2 ? '-- ' : (count === 3 ? '--- ' : ''))}</span>
                            {submenu.title}
                        </Link>

                        {submenu.submenu.length > 0 ?
                            <a
                                className='d-md-none d-inline-block nav-link px-2 me-2 float-end link-dark bg-danger'
                                id={submenu.title} data-bs-toggle="dropdown" data-bs-auto-close="outside"
                                onClick={() => handleDropdownToggle(submenu.title)}
                            >
                                {
                                    openDropdown === submenu.title ?
                                        <TiMinus className='ti-minus-mobile float-end fw-bold' />
                                        : <TiPlus className='ti-plus-mobile float-end fw-bold' />
                                }
                            </a>
                            : ''
                        }
                        {submenu.submenu.length > 0 ? <Submenu submenus={submenu.submenu} id={submenu.title} count={count} /> : ''}
                    </li>
                ))}
            </ul>
        </>
    )
}
