import React, { useEffect, useState } from 'react';
import Head from 'next/head';
import Link from 'next/link';
import Image from 'next/image';
import ReactDOMServer from 'react-dom/server';
import {
    FacebookShareButton,
    FacebookIcon,
    TwitterShareButton,
    XIcon,
    LinkedinShareButton,
    LinkedinIcon,
    EmailShareButton,
    EmailIcon,
    PinterestShareButton,
    PinterestIcon,
} from "react-share";
import moment from 'moment';
import laravelURL from '../utils/laravel-url';
import SkipTheWait from '../utils/skip-the-wait';
import mainURL from '../utils/main-url';
import LocationList from '../templates/location-list';
import parse from 'html-react-parser';

export default function Blog({ blog, locationSidebar }) {
    const [currentUrl, setCurrentUrl] = useState('');
    const element = <SkipTheWait />;

    useEffect(() => {
        setCurrentUrl(window.location.href);
    }, []);

    return (
        <>
            <div>
                <Head>
                    <title>{blog.seo_title}</title>
                    <meta name="description" content={blog.meta_description} />
                    <link rel='canonical' href={mainURL + '/' + blog.slug} />
                    <meta property="og:title" content={blog.title} />
                    <meta property="og:description" content={blog.meta_description} />
                    <meta property="og:url" content={mainURL + '/' + blog.slug} />
                    <meta property="og:image" content={laravelURL + '/storage/' + blog.image} />

                    {blog?.head && parse(blog?.head)}
                </Head>

                <div className='container'>
                    <br />
                    <div className='row'>
                        <div className='col-md-9'>
                            <h4 className='mb-4'><b>{blog.title}</b></h4>
                            <section>
                                {blog.image_show ? blog.image && (
                                    <Image
                                        src={laravelURL + '/storage/' + blog.image}
                                        alt={blog.title}
                                        width={1200} 
                                        height={630} 
                                        sizes="(max-width: 768px) 100vw, 1200px"
                                        className='w-100 h-auto'
                                        priority
                                    />
                                ):''}
                            </section>
                            <br/>
                            <section>
                                <div className='ck-content'>
                                    <div dangerouslySetInnerHTML={{ __html: blog.description.replace("skip-the-wait", ReactDOMServer.renderToStaticMarkup(element)) }} />
                                </div>
                            </section>
                            <br />
                            <section>
                                <div className='py-1 mt-3 border-top border-bottom'>
                                    <small>By <span>SignatureCare ER </span>
                                        | {moment(blog.date).format("MMM Do, YYYY")}
                                        | Categories: {blog.categories?.map((category, index) => (
                                            <span key={index}>
                                                {index > 0 ? ', ' : ''}
                                                <Link href={'/blog/categories/' + category.slug} style={{ color: 'hsl(0,100%,50%)' }}>{category.name}</Link>
                                            </span>
                                        ))}
                                    </small>
                                </div>
                            </section>
                            <br />
                            <section>
                                <div className='card border-0'>
                                    <div className='card-body p-4'>
                                        <div className='row text-center'>
                                            <div className='col-md'>
                                                Share this useful information with your friends!
                                            </div>
                                            <div className='col-md'>
                                                <div>
                                                    <FacebookShareButton windowWidth="800" windowHeight="500" url={currentUrl}>
                                                        <FacebookIcon size={36} />
                                                    </FacebookShareButton>
                                                    <TwitterShareButton windowWidth="800" windowHeight="500" url={currentUrl}>
                                                        <XIcon size={36} />
                                                    </TwitterShareButton>
                                                    <LinkedinShareButton windowWidth="800" windowHeight="500" url={currentUrl}>
                                                        <LinkedinIcon size={36} />
                                                    </LinkedinShareButton>
                                                    <PinterestShareButton windowWidth="800" windowHeight="500" url={currentUrl}>
                                                        <PinterestIcon size={36} />
                                                    </PinterestShareButton>
                                                    <EmailShareButton windowWidth="800" windowHeight="500" url={currentUrl}>
                                                        <EmailIcon size={36} />
                                                    </EmailShareButton>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </section>
                            <br />
                            <section>
                                <h5 className='d-flex'>Related Blog Posts &nbsp; <hr className='w-25' /></h5>
                            </section>
                            <br />

                            {/* ✅ Bootstrap Carousel - 3 cards per slide */}
                            <section>
                                <div id="relatedBlogsCarousel" className="carousel slide" data-bs-ride="carousel">
                                    <div className="carousel-inner">
                                    {blog.relatedBlog?.reduce((acc, relatedBlog, index) => {
                                        // Group blogs into sets of 3
                                        const slideIndex = Math.floor(index / 3);
                                        if (!acc[slideIndex]) {
                                            acc[slideIndex] = [];
                                        }
                                        acc[slideIndex].push(relatedBlog);
                                        return acc;
                                    }, []).map((blogGroup, slideIndex) => (
                                        <div key={slideIndex} className={`carousel-item ${slideIndex === 0 ? 'active' : ''}`}>
                                        <div className="row justify-content-center g-3">
                                            {blogGroup.map((relatedBlog, cardIndex) => (
                                                <div key={cardIndex} className="col-12 col-md-4">
                                                    <div className="card border-0 h-100">
                                                    <Image
                                                        src={laravelURL + "/storage/" + relatedBlog.image}
                                                        alt={relatedBlog.title}
                                                        width={320}
                                                        height={200}
                                                        sizes="(max-width: 768px) 100vw, 320px"
                                                        className="card-img-top object-fit-cover"
                                                    />
                                                    <div className="card-body">
                                                        <h5 className="card-title">
                                                        <Link href={'/' + relatedBlog.slug} style={{ color: 'hsl(0,100%,50%)' }}>
                                                            {relatedBlog.title}
                                                        </Link>
                                                        </h5>
                                                        <p className="card-text">{moment(relatedBlog.date).format("MMM Do, YYYY")}</p>
                                                    </div>
                                                    </div>
                                                </div>
                                            ))}
                                        </div>
                                        </div>
                                    ))}
                                    </div>
                                    
                                    {/* Carousel Controls */}
                                    {blog.relatedBlog?.length > 3 && (
                                    <>
                                        <button className="carousel-control-prev" type="button" data-bs-target="#relatedBlogsCarousel" data-bs-slide="prev">
                                        <span className="carousel-control-prev-icon bg-dark rounded-circle p-3" aria-hidden="true"></span>
                                        <span className="visually-hidden">Previous</span>
                                        </button>
                                        <button className="carousel-control-next" type="button" data-bs-target="#relatedBlogsCarousel" data-bs-slide="next">
                                        <span className="carousel-control-next-icon bg-dark rounded-circle p-3" aria-hidden="true"></span>
                                        <span className="visually-hidden">Next</span>
                                        </button>

                                        {/* Indicators */}
                                        <div className="carousel-indicators">
                                        {Array.from({ length: Math.ceil(blog.relatedBlog.length / 3) }).map((_, index) => (
                                            <button
                                            key={index}
                                            type="button"
                                            data-bs-target="#relatedBlogsCarousel"
                                            data-bs-slide-to={index}
                                            className={index === 0 ? 'active' : ''}
                                            aria-current={index === 0 ? 'true' : 'false'}
                                            aria-label={`Slide ${index + 1}`}
                                            ></button>
                                        ))}
                                        </div>
                                    </>
                                    )}
                                </div>
                            </section>
                            
                            <br />
                            <br />
                        </div>

                        <div className='col-md-3'>
                            <LocationList locationSidebar={locationSidebar} />
                        </div>
                    </div>
                </div>
            </div>

            {blog?.bottom && parse(blog?.bottom)}
        </>
    )
}