import React from 'react'
import { SocialIcon } from 'react-social-icons';
import { GoogleMap, useLoadScript, Marker } from '@react-google-maps/api';
import Head from 'next/head';
import laravelURL from '../utils/laravel-url';
import Link from 'next/link';
import Image from 'next/image';
import ReactDOMServer from 'react-dom/server';
import SkipTheWait from '../utils/skip-the-wait';
import mainURL from '../utils/main-url';
import parse from 'html-react-parser';

const containerStyle = {
    width: '100%',
    height: '400px'
};

export default function Location({ location, locationContent }) {
    const element = <SkipTheWait />;

    const { isLoaded } = useLoadScript({
        id: 'google-map-script',
        googleMapsApiKey: process.env.NEXT_PUBLIC_API_KEY
    });

    return (
        <>
            <div>
                <Head>
                    <title>{location.seo_title}</title>
                    <meta name="description" content={location.meta_description} />
                    <link rel='canonical' href={mainURL + '/' + location.slug} />

                    <meta property="og:title" content={location.seo_title} />
                    <meta property="og:description" content={location.meta_description} />
                    <meta property="og:url" content={mainURL + '/' + location.slug} />
                    <meta property="og:image" content={laravelURL + '/storage/' + location.img} />

                    {location?.head &&
                        parse(location?.head)
                    }
                </Head>

                <div className='bg-dark text-white'>
                    <div className='text-center'>
                        <h3 className='py-2'>{location.title}</h3>
                    </div>
                </div>

                <div className="py-3 text-center h4">
                    <h3>SignatureCare Emergency Center {location.relative_location && 'Near'} {location.name}, {location.state} <span style={{ color: 'hsl(0,100%,50%)' }}></span></h3>
                </div>

                <div className="bg-white text-center shadow border-bottom p-inline-5">
                    <SocialIcon url={location.facebook} network="facebook" style={{ height: 40, width: 40, margin: '0px 1px' }} title='Facebook' />
                    <SocialIcon url={location.twitter} network="x" style={{ height: 40, width: 40, margin: '0px 1px' }} title='Twitter' />
                    <SocialIcon url={location.youtube} network="youtube" style={{ height: 40, width: 40, margin: '0px 1px' }} title='Youtube' />
                    <SocialIcon url={location.instagram} network="instagram" style={{ height: 40, width: 40, margin: '0px 1px' }} title='Instagram' />
                    <SocialIcon url={location.linkedin} network="linkedin" style={{ height: 40, width: 40, margin: '0px 1px' }} title='Linkedin' />
                    {/* <SocialIcon url={location.yelp} network="yelp" style={{ height: 40, width: 40, margin: '0px 1px' }} title='Yelp' /> */}
                    <SocialIcon url={location.tiktok} network="tiktok" style={{ height: 40, width: 40, margin: '0px 1px' }} title='Yelp' />
                </div>

                <br />

                <div className='container'>
                    <div className='row'>
                        <div className='col-md-6'>
                            {/* <div className="h3">
                                {location.title} {!location.title.includes(location.zip) && location.zip}
                            </div>

                            <div className="text-center h3 text-dark" style={{ backgroundColor: '#33FF4C' }}>
                                — — — OPEN 24 HOURS — — —
                            </div>

                            <p>Your Care is our Signature</p> */}

                            {/* SubHeading Section */}
                            <section>
                                <div className='ck-content'>
                                    <div dangerouslySetInnerHTML={{ __html: location.subheading }} />
                                </div>
                            </section>

                            <SkipTheWait url={location.acuity_url} />
                            <br />

                            <address>
                                <Link href={location.google || ''} target={"_blank"} className="btn btn-danger">Get Direction</Link> <b>Address:</b> {location.address}
                                <p>
                                    <Image
                                        src={laravelURL + "/storage/" + location.tel_image}
                                        width="0"
                                        height="0"
                                        sizes="100vw"
                                        style={{ width: 'auto', height: 'auto' }}
                                        alt='telephone image'
                                    />
                                    &nbsp;/&nbsp;<b> Tel: <Link href={"tel:" + location.tel} style={{ color: 'hsl(0,100%,50%)' }}>{location.tel}</Link>
                                    </b>
                                </p>
                            </address>

                            {location.image_show ? location.img && (
                                <Image
                                    src={laravelURL + "/storage/" + location.img}
                                    alt={location.title}
                                    width={1920}
                                    height={600}
                                    sizes="100vw"
                                    className="w-100 h-auto mb-4"
                                    style={{ maxHeight: '600px', objectFit: 'cover' }}
                                    priority
                                />
                            ): ''}

                            <div className='w-100 d-block' style={{ maxWidth: '100%' }}>
                                <div className='ck-content'>
                                    <div dangerouslySetInnerHTML={{ __html: location.description?.replace("skip-the-wait", ReactDOMServer.renderToStaticMarkup(element)) }} />
                                </div>
                            </div>
                        </div>

                        <div className='col-md-6'>
                            <section>
                                <div className='ck-content'>
                                    <div dangerouslySetInnerHTML={{ __html: locationContent.first }} />
                                </div>
                            </section>

                            <br />

                            {isLoaded ? (
                                <GoogleMap
                                    mapContainerStyle={containerStyle}
                                    center={{ lat: location.latitude, lng: location.longitude }}
                                    zoom={17}
                                >
                                    <Marker position={{ lat: location.latitude, lng: location.longitude }} />
                                </GoogleMap>
                            ) : <></>
                            }
                            <br />
                            <section>
                                <div className='ck-content'>
                                    <div dangerouslySetInnerHTML={{ __html: location.destination }} />
                                </div>

                                <div className='row'>
                                    <div className='col-md-12 mb-3'>
                                        <p><b>Inside SignatureCare Emergency Center - {location.name}, {location.state} {location.zip}</b></p>
                                        {location.slider_images?.map((item, key) =>
                                            <div key={key}>
                                                <Image
                                                    src={laravelURL + "/storage/" + item}
                                                    alt={location.title + '-' + key}
                                                    width="500" height="380" sizes='100vw'
                                                    className="w-100 h-100 mb-3"
                                                />
                                            </div>
                                        )
                                        }
                                    </div>

                                    <div className='col-md-12 mb-3'>
                                        {location.vid &&
                                            <video width="500" height="350" className="d-block w-100 h-100" controls autoPlay muted>
                                                <source src={laravelURL + "/storage/" + location.vid} type="video/mp4" />
                                                Your browser does not support HTML video.
                                            </video>
                                        }
                                    </div>
                                </div>
                            </section>
                            <br />
                        </div>
                    </div>
                    <br />
                </div>
            </div>

            {location?.bottom &&
                parse(location?.bottom)
            }
        </>
    )
}