import Head from 'next/head';
import Image from 'next/image';
import React from 'react'
import laravelURL from '../utils/laravel-url';
import SkipTheWait from '../utils/skip-the-wait';
import ReactDOMServer from 'react-dom/server';
import mainURL from '../utils/main-url';
import LocationList from '../templates/location-list';
import SymptomList from '../templates/symptom-list';
import LocationPreview from '../templates/location-preview';
import parse from 'html-react-parser';

export default function Page({ page, locations, locationSidebar, symptomSidebar }) {
    const element = <SkipTheWait />;

    return (
        <>
            <Head>
                <title>{page.seo_title}</title>
                <meta name="description" content={page.meta_description} />
                <link rel='canonical' href={mainURL + '/' + page.slug} />

                <meta property="og:title" content={page.title} />
                <meta property="og:description" content={page.meta_description} />
                <meta property="og:url" content={mainURL + '/' + page.slug} />
                <meta property="og:image" content={laravelURL + '/storage/' + page.image} />

                {page?.head &&
                    parse(page?.head)
                }
            </Head>

            <div className='bg-dark text-white'>
                <div className='container text-center'>
                    <h3 className='py-2'>{page.title}</h3>
                </div>
            </div>
            <br />
            <div className='container'>
                <div className='row'>
                    <div className={`${page.right_nav ? 'col-md-9' : 'col-md-12'}`}>
                        {page.image_show ? page.image &&
                            <Image
                                src={laravelURL + "/storage/" + page.image}
                                alt={page.title}
                                width={1920}
                                height={600}
                                sizes="100vw"
                                className="w-100 h-auto mb-4"
                                style={{ maxHeight: '600px', objectFit: 'cover' }}
                                quality={80}
                                priority
                            />
                            : ''
                        }

                        <br />
                        <br />
                        
                        <section>
                            <div className='ck-content'>
                                <div dangerouslySetInnerHTML={{ __html: page.description.replace("skip-the-wait", ReactDOMServer.renderToStaticMarkup(element)) }} />
                            </div>
                        </section>

                        <section>
                            {page.bottom_nav === 'location' &&
                                <div>
                                    <hr className='curve my-4' />
                                    <LocationPreview locations={locations} />
                                </div>
                            }
                        </section>
                    </div>
                    <div className={`${page.right_nav ? 'col-md-3' : ''}`}>
                        {page.right_nav === 'location' &&
                            <LocationList locationSidebar={locationSidebar} />
                        }
                        {page.right_nav === 'symptom' &&
                            <SymptomList symptomSidebar={symptomSidebar} />
                        }
                    </div>
                </div>
            </div>
            <br />
            <br />

            {page?.bottom &&
                parse(page?.bottom)
            }
        </>
    )
}
