import Head from 'next/head';
import Image from 'next/image';
import React from 'react'
import laravelURL from '../utils/laravel-url';
import SkipTheWait from '../utils/skip-the-wait';
import ReactDOMServer from 'react-dom/server';
import mainURL from '../utils/main-url';
import SymptomList from '../templates/symptom-list';
import parse from 'html-react-parser';

export default function Symptom({ symptom, symptomSidebar }) {
    const element = <SkipTheWait />;

    return (
        <>
            <Head>
                <title>{symptom.seo_title}</title>
                <meta name="description" content={symptom.meta_description} />
                <link rel='canonical' href={mainURL + '/' + symptom.slug} />

                <meta property="og:title" content={symptom.title} />
                <meta property="og:description" content={symptom.meta_description} />
                <meta property="og:url" content={mainURL + '/' + symptom.slug} />
                <meta property="og:image" content={laravelURL + '/storage/' + symptom.image} />

                {symptom?.head &&
                    parse(symptom?.head)
                }
            </Head>

            <div className='bg-dark text-white'>
                <div className='container text-center'>
                    <h3 className='py-2'>{symptom.title}</h3>
                </div>
            </div>
            <br />
            <div className='container'>
                <div className='row'>
                    <div className='col-md-8'>
                        {symptom.image_show ?
                            symptom.image &&
                            <Image
                                src={laravelURL + "/storage/" + symptom.image}
                                alt={symptom.image}
                                width={1920}
                                height={600}
                                sizes="100vw"
                                className="w-100 h-auto mb-4"
                                style={{ maxHeight: '600px', objectFit: 'cover' }}
                                quality={80}
                                priority
                            />
                            :
                            ''
                        }
                        <br />
                        <br />
                        <section>
                            <div className='ck-content'>
                                <div dangerouslySetInnerHTML={{ __html: symptom.description.replace("skip-the-wait", ReactDOMServer.renderToStaticMarkup(element)) }} />
                            </div>
                        </section>
                    </div>
                    <div className='col-md-4'>
                        <SymptomList symptomSidebar={symptomSidebar} />
                    </div>
                </div>
            </div>
            <br />
            <br />

            {symptom?.bottom &&
                parse(symptom?.bottom)
            }
        </>
    )
}
