import React, { useEffect } from 'react';
import { RiArrowRightSLine } from 'react-icons/ri';
import Link from 'next/link';

export default function LocationList({ locationSidebar }) {
    return (
        <>
            <ul className="list-group list-group-flush border-bottom">
                {locationSidebar?.map((location, index) => (
                    <li className="list-group-item list-group-item-action px-0" key={index}>
                        <Link href={location.url} className='text-danger'>
                            <RiArrowRightSLine /> {location.title}
                        </Link>
                    </li>
                ))
                }
            </ul>
        </>
    )
}
