import Image from "next/image";
import Link from "next/link";
import React from "react";
import laravelURL from "../utils/laravel-url";

export default function LocationPreviewWithImage({
  locations,
  appointment
}) {
  locations = locations.filter(
    (location) => location.name !== "Greater Texas Division"
  );
  locations = locations.filter(
    (location) => location.status !== 2
  );

  return (
    <>
      <div className="row">
        {locations?.map((location, index) => (
          <div className="col-md-4 d-flex align-items-stretch" key={index}>
            <div className="card border-0">
              <p>
                <strong>
                  {location.name}, {location.state}
                </strong>
              </p>
              {appointment && (
                <div>
                  <Image
                    width={500}
                    height={200}
                    src={laravelURL + "/storage/" + location.img}
                    alt="location img"
                    className="d-block mb-3"
                  />
                </div>
              )}

              {location?.google && (
                <div>
                  <Link
                    href={location.google}
                    className="btn btn-danger px-4 btn-sm rounded-0"
                    target={"_blank"}
                    rel="noreferrer"
                  >
                    <small>
                      <strong>Get Directions</strong>
                    </small>
                  </Link>
                </div>
              )}
              <address>
                {location.street}
                <br />
                {location.city}, {location.zip}
                <br />
                Tel:{" "}
                <strong>
                  <Link
                    href={"tel:" + location.tel}
                    className="text-danger"
                    rel="noreferrer"
                  >
                    {location.tel}
                  </Link>
                </strong>
                <br />
                {appointment && (
                  <Link
                    href={location.acuity_url || "#"}
                    target={location.acuity_url ? "_blank" : undefined}
                    rel={location.acuity_url ? "noreferrer" : undefined}
                    className="btn btn-dark"
                    onClick={(e) => {
                      if (!location.acuity_url) e.preventDefault();
                    }}
                  >
                    <small>EMERGENCY ROOM APPOINTMENT</small>
                  </Link>
                )}
              </address>
              <hr />
            </div>
          </div>
        ))}
      </div>
    </>
  );
}
