import Image from "next/image";
import Link from "next/link";
import React from "react";
import laravelURL from "../utils/laravel-url";

export default function LocationPreview({
  locations,
  appointment,
  activeJobs,
  city,
  chargemaster,
}) {
  if (city === "Houston") {
    var houstonLocations = locations.filter((location) =>
      location.city.includes("Houston")
    );
    locations = houstonLocations;
  }

  if (!activeJobs) {
    locations = locations.filter(
      (location) => location.name !== "Greater Texas Division"
    );
  }

  return (
    <>
      <div className="row">
        {locations?.map((location, index) => (
          <div className="col-md-4 d-flex align-items-stretch" key={index}>
            <div className="card border-0">
              <p>
                <strong>
                  {location.name}, {location.state}{" "}
                  {location.status === 2 && (
                    <>
                      <span className="text-danger">(</span>
                      <span className="text-danger">coming soon</span>
                      <span className="text-danger">)</span>
                    </>
                  )}
                </strong>
              </p>
              {appointment && (
                <div>
                  <Image
                    width={500}
                    height={200}
                    src={laravelURL + "/storage/" + location.img}
                    alt="location img"
                    className="d-block mb-3"
                  />
                </div>
              )}
              {activeJobs && (
                <ul className="text-danger list-unstyled">
                  {activeJobs[location.id] &&
                    activeJobs[location.id].map((job, index) => (
                      <li key={index}>
                        <small>
                          <b>{job.position}</b>
                        </small>
                      </li>
                    ))}
                </ul>
              )}
              {location?.google && (
                <div>
                  <Link
                    href={location.google}
                    className="btn btn-danger px-4 btn-sm rounded-0"
                    target={"_blank"}
                    rel="noreferrer"
                  >
                    <small>
                      <strong>Get Directions</strong>
                    </small>
                  </Link>
                </div>
              )}
              <address>
                {location.street}
                <br />
                {location.city}, {location.zip}
                <br />
                Tel:{" "}
                <strong>
                  <Link
                    href={"tel:" + location.tel}
                    className="text-danger"
                    rel="noreferrer"
                  >
                    {location.tel}
                  </Link>
                </strong>
                <br />
                {appointment && (
                  <Link
                    href={location.acuity_url || "#"}
                    target={location.acuity_url ? "_blank" : undefined}
                    rel={location.acuity_url ? "noreferrer" : undefined}
                    className="btn btn-dark"
                    onClick={(e) => {
                      if (!location.acuity_url) e.preventDefault();
                    }}
                  >
                    <small>EMERGENCY ROOM APPOINTMENT</small>
                  </Link>
                )}
              </address>
              {chargemaster && (
                <div>
                  <Link
                    href={chargemaster}
                    className="btn btn-dark"
                    rel="noreferrer"
                  >
                    Chargemaster List
                  </Link>
                </div>
              )}
              <hr />
            </div>
          </div>
        ))}
      </div>
    </>
  );
}
