import React from 'react'
import { RiArrowRightSLine } from 'react-icons/ri';
import Link from 'next/link';

export default function SymptomList({ symptomSidebar }) {
    return (
        <>
            <div><b>Emergency Room Symptoms</b><br /></div>
            <br />
            <ul className="list-group list-group-flush border-bottom">
                {symptomSidebar?.map((symptom, index) => (
                        <li className="list-group-item list-group-item-action px-0" key={index}>
                            <Link href={symptom.url} style={{ color: 'red' }}>
                                <RiArrowRightSLine /> {symptom.title}
                            </Link>
                        </li>
                    ))
                }
            </ul>
        </>
    )
}
