import Script from "next/script";
import { useEffect, useState } from "react";

export default function ThirdPartyScripts() {
  const [mounted, setMounted] = useState(false);

  useEffect(() => {
    setMounted(true);
  }, []);

  if (!mounted) return null;

  return (
    <>
      {/* Google Tag Manager - Critical, load first */}
      <Script
        id="gtm"
        strategy="afterInteractive"
        dangerouslySetInnerHTML={{
          __html: `
            (function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
            new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
            j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
            'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
            })(window,document,'script','dataLayer','GTM-TPFJKG6');
          `,
        }}
      />

      {/* Google Ads Gtag - Load before conversion */}
      <Script
        id="gtag-js"
        src="https://www.googletagmanager.com/gtag/js?id=AW-968527529"
        strategy="lazyOnload"
      />

      <Script
        id="gtag-config"
        strategy="lazyOnload"
        dangerouslySetInnerHTML={{
          __html: `
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());
            gtag('config', 'AW-968527529');
          `,
        }}
      />

      {/* Google Ads Conversion */}
      <Script
        id="google-ads-conversion"
        src="https://www.googleadservices.com/pagead/conversion.js"
        strategy="lazyOnload"
      />

      {/* WebChat ODL */}
      <Script
        id="webchat-odl"
        strategy="lazyOnload"
        dangerouslySetInnerHTML={{
          __html: `
            window.site_url = 'https://webchat.ercare24.com';
            (function(o,d,e,s,k){
              o[s]=o[s]||function(){(o[s].prop=o[s].prop||[]).push(arguments)};
              o[s]('key','SignatureCare Emergency Center');
              o[s]('url',o['site_url']);
              var a=d.createElement(e),m=d.getElementsByTagName(e)[0];
              a.async=1;a.src=o['site_url']+k;
              m.parentNode.insertBefore(a,m);
            })(window,document,'script','ODL','/js/fe/odl.min.js');
          `,
        }}
      />

      {/* CallRail */}
      <Script
        id="callrail"
        src="https://cdn.callrail.com/companies/160509629/96a63178e66facbcd7eb/12/swap.js"
        strategy="lazyOnload"
      />

      {/* BrandCDN Chron */}
      <Script
        id="brandcdn"
        src="https://tag.brandcdn.com/autoscript/signaturecareemergencycenters_vfzsvmvfovvzeja9/chron.js"
        strategy="lazyOnload"
      />

      {/* CHEQ4PPC (ClickCease) - Only one instance needed */}
      <Script
        id="cheq4ppc"
        src="https://ob.segreencolumn.com/i/c9423f01bcf350d77ced0f46c2917f7c.js"
        strategy="lazyOnload"
        data-ch="cheq4ppc"
        onError={(e) => console.error('CHEQ script failed:', e)}
      />

      {/* GTM Noscript */}
      <noscript>
        <iframe
          src="https://www.googletagmanager.com/ns.html?id=GTM-TPFJKG6"
          height="0"
          width="0"
          style={{ display: "none", visibility: "hidden" }}
        />
      </noscript>

      {/* Google Ads Noscript */}
      <noscript>
        <div style={{ display: "inline" }}>
          <img
            height="1"
            width="1"
            style={{ borderStyle: "none" }}
            alt=""
            src="//googleads.g.doubleclick.net/pagead/viewthroughconversion/968527529/?guid=ON&script=0"
          />
        </div>
      </noscript>
    </>
  );
}
