import { NextResponse } from 'next/server'
import laravelURL from './components/utils/laravel-url';

export async function middleware(request) {
    const { pathname } = request.nextUrl;
    const res = await fetch(laravelURL + '/api/admin/redirects');
    const redirects = await res.json();

    // console.log('middleware:::' + pathname)

    if (pathname.startsWith('/er-services/')) {
        const pathParts = pathname.split('/');
        const slug = pathParts[pathParts.length - 1];
        return NextResponse.rewrite(new URL('/' + slug, request.url))
    }

    // if (pathname.startsWith('/blog/')) {
    //     const pathParts = pathname.split('/');
    //     const slug = pathParts[pathParts.length - 1];
    //     return NextResponse.redirect(new URL('/' + slug, request.url))
    // }

    const redirect = redirects.find((redirect) => pathname === redirect.source);

    if (redirect) {
        // console.log('middleware-check');
        if (redirect.destination.startsWith('http') || redirect.destination.startsWith('https')) {
            return NextResponse.redirect(new URL(redirect.destination));
        }
        return NextResponse.redirect(new URL(redirect.destination, request.url));
    }

    // Continue if no matching redirect is found
    return NextResponse.next();
}