import { SessionProvider } from 'next-auth/react'
import { Merriweather } from '@next/font/google'
import { LayoutProvider } from '../contexts/LayoutContext'
import MainLayout from '../components/layouts/main-layout'
import BootstrapLoader from '../components/utils/BootstrapLoader'
// import ThirdPartyScripts from '../components/utils/ThirdPartyScripts';
import 'bootstrap/dist/css/bootstrap.min.css'
import '../styles/globals.css'
import '../styles/main-layout.css'
import '../styles/content-style.css'
import '../styles/home.css'

const merriweather = Merriweather({
	subsets: ['latin'],
	style: ['normal', 'italic'],
	weight: ['300', '400', '700', '900'],
	display: 'swap',
	preload: true,
	fallback: ['Georgia', 'serif'],
	adjustFontFallback: true,
})

export default function App({ Component, pageProps }) {
	const getLayout = Component.getLayout || ((page) => page)
	const layoutData = pageProps.layoutData || {}

	return (
		<SessionProvider session={pageProps.session}>
			<LayoutProvider layoutData={layoutData}>
				<main className={merriweather.className}>
					<MainLayout>
						{getLayout(<Component {...pageProps} />)}
					</MainLayout>
					{/* <ThirdPartyScripts /> */}
					<BootstrapLoader />
				</main>
			</LayoutProvider>
		</SessionProvider>
	)
}