import { Html, Head, Main, NextScript } from 'next/document'

export default function Document() {
	return (
		<Html lang="en">
			<Head>
				<link rel="shortcut icon" href="/assets/signaturecare-mini.webp" type="image/webp" />

				{/* Preconnect - Only for critical resources */}
				<link rel="preconnect" href="https://fonts.gstatic.com" crossOrigin="anonymous" />
				<link rel="preconnect" href="https://backend.ercare24.com" />

				{/* DNS Prefetch - For third-party domains */}
				<link rel="dns-prefetch" href="https://www.googletagmanager.com" />
				<link rel="dns-prefetch" href="https://maps.googleapis.com" />
				<link rel="dns-prefetch" href="https://webchat.ercare24.com" />
			</Head>

			<body>
				<Main />
				<NextScript />
			</body>
		</Html>
	)
}