import Head from "next/head";
import Image from "next/image";
import React from "react";
import http from "../components/utils/http";
import laravelURL from "../components/utils/laravel-url";
import mainURL from "../components/utils/main-url";
import SkipTheWait from "../components/utils/skip-the-wait";
import ReactDOMServer from "react-dom/server";
import parse from "html-react-parser";
import { getLayoutData } from "../components/utils/getLayoutData";

export default function AwardRecognition({ awards, page }) {
  const element = <SkipTheWait />;

  return (
    <>
      <Head>
        <title>{page.seo_title}</title>
        <meta name="description" content={page.meta_description} />
        <link rel="canonical" href={mainURL + "/awards-recognition/"} />
        <meta property="og:locale" content="en_US" />
        <meta property="og:type" content="article" />
        <meta property="og:title" content={page.seo_title} />
        <meta property="og:url" content={mainURL + "/awards-recognition/"} />
        <meta
          property="og:site_name"
          content="Emergency Room: SignatureCare Emergency Center 24-Hour ER"
        />
        <meta
          property="article:publisher"
          content="https://www.facebook.com/SignatureCareER/"
        />
        <meta
          property="og:image"
          content={laravelURL + "/storage/" + page.image}
        />

        {page?.head && parse(page?.head)}
      </Head>

      <section>
        <div className="text-center bg-dark text-white">
          <h3 className="py-2">{page.title}</h3>
        </div>
      </section>

      <br />

      <div className="container-fluid px-0">
        {page.image_show && page.image ? (
          <Image
            src={laravelURL + "/storage/" + page.image}
            alt={page.title}
            width={1920}
            height={600}
            sizes="100vw"
            className="w-100 h-auto mb-4"
            style={{ maxHeight: "600px", objectFit: "cover" }}
            priority
          />
        ) : null}
      </div>

      <br />

      <section className="container">
        <div className="ck-content">
          <div
            dangerouslySetInnerHTML={{
              __html: page.description.replace(
                "skip-the-wait",
                ReactDOMServer.renderToStaticMarkup(element)
              ),
            }}
          />
        </div>
      </section>

      <br />
      <section>
        <center>
          <hr className="w-50 curve" />
        </center>
      </section>
      <br />

      <div className="container">
        <div className="row">
          {awards &&
            awards.map((award, index) => (
              <div className="col-md-4 d-flex align-items-stretch" key={index}>
                <center>
                  <Image
                    alt="Award image"
                    src={laravelURL + "/storage/" + award.image}
                    width="0"
                    height="190"
                    sizes="100vw"
                    style={{ width: "auto", height: "190" }}
                  />
                  <br />
                  <p>
                    <b>
                      <i>{award.host} - </i>
                    </b>
                    {award.title}
                  </p>
                  <hr />
                </center>
              </div>
            ))}
        </div>
      </div>

      <br />
      <br />
      <br />

      {page?.bottom && parse(page?.bottom)}
    </>
  );
}

export const getStaticProps = async () => {
  try {
    // Fetch both endpoints in parallel
    const [awardsRes, textRes, layoutData] = await Promise.all([
      http.get("/admin/awards"),
      http.get("/admin/pages/awards-recognition-text"),
      getLayoutData(),
    ]);

    const awards = awardsRes.data || [];
    const page = textRes.data || {};

    return {
      props: {
        awards,
        page,
        layoutData,
      },
      revalidate: 10,
    };
  } catch (err) {
    console.error("Error fetching awards page data:", err.message);

    // Option 1: Return 404 page
    return { notFound: true };

    // Option 2: Or fallback empty props to still build
    // return {
    //   props: {
    //     awards: [],
    //     page: {},
    //   },
    //   revalidate: 10,
    // };
  }
};
