import React from 'react'
import http from '../components/utils/http';
import LocationList from '../components/templates/location-list';
import SkipTheWait from '../components/utils/skip-the-wait';
import { useRouter } from 'next/router';
import Head from 'next/head';
import Map from '../components/templates/map';
import mainURL from '../components/utils/main-url';
import LocationPreview from '../components/templates/location-preview';
import ReactDOMServer from 'react-dom/server';
import laravelURL from '../components/utils/laravel-url';
import parse from 'html-react-parser'
import { getLayoutData } from "../components/utils/getLayoutData";

export default function ClosestEmergencyRoom({ page, locations, locationSidebar }) {
    const router = useRouter();
    const element = <SkipTheWait />;

    if (router.isFallback) {
        return <h1>Loading...</h1>
    }

    return (
        <>
            <Head>
                <title>{page.seo_title}</title>
                <meta name="description" content={page.meta_description} />
                <link rel="canonical" href={mainURL + "/closest-emergency-room"} />
                <meta property="og:locale" content="en_US" />
                <meta property="og:type" content="article" />
                <meta property="og:title" content={page.seo_title} />
                <meta property="og:url" content={mainURL + "/closest-emergency-room"} />
                <meta property="og:site_name" content="Emergency Room: SignatureCare Emergency Center 24-Hour ER" />
                <meta property="article:publisher" content="https://www.facebook.com/SignatureCareER/" />
                <meta property="article:modified_time" content="2022-10-21T19:00:08+00:00" />
                <meta property="og:image" content={laravelURL + '/storage/' + page.image} />

                {page?.head &&
                    parse(page?.head)
                }
            </Head>

            <div className='bg-dark text-white'>
                <div className='container text-center'>
                    <h3 className='py-2'>Closest Emergency Room</h3>
                </div>
            </div>
            <br />
            <div className='container'>
                <div className='row'>
                    <div className='col-md-9'>

                        <Map />

                        <br />
                        <section>
                            <div className='ck-content'>
                                <div dangerouslySetInnerHTML={{ __html: page.description.replace("skip-the-wait", ReactDOMServer.renderToStaticMarkup(element)) }} />
                            </div>
                        </section>
                        <br />
                        <section>
                            <LocationPreview locations={locations} />
                        </section>
                    </div>
                    <div className='col-md-3'>
                        <LocationList locationSidebar={locationSidebar} />
                    </div>
                </div>
            </div>
            <br />
            <br />
            <br />
            <br />

            {page?.bottom &&
                parse(page?.bottom)
            }
        </>
    )
}

export const getStaticProps = async () => {
  try {
    const [locationsRes, pageRes, sidebarRes, layoutData] = await Promise.all([
      http.get('/admin/locations'),
      http.get('/admin/pages/closest-emergency-room-text'),
      http.get('/admin/navigations/location-sidebar'),
      getLayoutData(),
    ]);

    return {
      props: {
        locations: locationsRes.data || [],
        page: pageRes.data || {},
        locationSidebar: JSON.parse(sidebarRes.data?.menus || '[]'),
        layoutData,
      },
      revalidate: 10,
    };
  } catch (err) {
    console.error('Error fetching static props:', err.message);
    return { notFound: true };
  }
};
