import Head from 'next/head'
import mainURL from '../components/utils/main-url'
import LocationPreviewWithImage from '../components/templates/location-preview-with-image'
import http from '../components/utils/http'
import SkipTheWait from '../components/utils/skip-the-wait';
import ReactDOMServer from 'react-dom/server';
import laravelURL from '../components/utils/laravel-url'
import parse from 'html-react-parser'
import { getLayoutData } from "../components/utils/getLayoutData";

export default function GetAppointment({ page, locations }) {
    const element = <SkipTheWait />;

    return (
        <>
            <Head>
                <title>{page.seo_title}</title>
                <meta name="description" content={page.meta_description} />
                <link rel="canonical" href={mainURL + "/emergency-room-appointment/"} />
                <meta property="og:locale" content="en_US" /><meta property="og:type" content="article" />
                <meta property="og:title" content={page.seo_title} />
                <meta property="og:url" content={mainURL + "/emergency-room-appointment/"} />
                <meta property="og:site_name" content="Emergency Room: SignatureCare Emergency Center 24-Hour ER" />
                <meta property="article:publisher" content="https://www.facebook.com/SignatureCareER/" />
                <meta property="article:modified_time" content="2022-10-24T17:50:51+00:00" />
                <meta property="og:image" content={laravelURL + '/storage/' + page.image} />

                {page?.head &&
                    parse(page?.head)
                }
            </Head>
            <div className='bg-dark text-white'>
                <div className='container text-center'>
                    <h3 className='py-2'>{page.title}</h3>
                </div>
            </div>
            <br />
            <br />
            <br />
            <div className='container'>
                {/* Editable text comming from backend */}
                <section>
                    <div className='ck-content'>
                        <div dangerouslySetInnerHTML={{ __html: page.description.replace("skip-the-wait", ReactDOMServer.renderToStaticMarkup(element)) }} />
                    </div>
                </section>

                <center>
                    <hr className='w-50 curve' />
                </center>

                <LocationPreviewWithImage locations={locations} appointment={true} />

                <br />
                <br />
            </div>

            {page?.bottom &&
                parse(page?.bottom)
            }
        </>
    )
}

export const getStaticProps = async () => {
  try {
    const [locationsRes, pageRes, layoutData] = await Promise.all([
      http.get('/admin/locations'),
      http.get('/admin/pages/emergency-room-appointment-text'),
      getLayoutData(),
    ]);

    return {
      props: {
        locations: locationsRes.data || [],
        page: pageRes.data || {},
        layoutData,
      },
      revalidate: 10,
    };
  } catch (err) {
    console.error('Error fetching static props:', err.message);
    return { notFound: true };
  }
};
