import Head from 'next/head';
import Image from 'next/image';
import Link from 'next/link';
import { useRouter } from 'next/router';
import React, { useState } from 'react'
import { Form } from 'react-bootstrap';
import http from '../../components/utils/http';
import laravelURL from '../../components/utils/laravel-url';
import mainURL from '../../components/utils/main-url';
import { getLayoutData } from "../../components/utils/getLayoutData";

export default function Grade({ locations }) {
    const router = useRouter();
    const [filterLocation, setFilterLocation] = useState(locations);

    if (router.isFallback) {
        return <h1>Loading...</h1>
    }

    const searchLocation = (search) => {
        const result = locations.filter((location) => {
            return location.name.toLowerCase().match(search.toLowerCase());
        });
        setFilterLocation(result);
    }

    return (
        <>
            <Head>
                <title>Review Us Today - SignatureCare Emergency Center, TX</title>
                <meta name="description" content="Write a review today. Rate us and let us know about the service you received at SignatureCare Emergency Center, TX" />
                <meta name="keywords" content="signaturecare emergency center, 24-hour emergency room, 24-hour er, emergency center, emergency clinic" />
                <link rel='canonical' href={mainURL + '/grade/'} />
            </Head>
            <div className='container mb-5'>
                <Form.Control type="text" className='mb-3' onChange={(e) => searchLocation(e.target.value)} placeholder="Search SignatureCare ER" />
                <div className='row'>
                    {filterLocation &&
                        filterLocation.map((location, index) => (
                            <div className='col-md-4 mb-3' key={index}>
                                <Link href={`/grade/${location.slug}`}>
                                    <div style={{ position: 'relative', minHeight: '250px' }}>
                                        <Image
                                            src={laravelURL + '/storage/' + location.img}
                                            alt={location.name}
                                            width={300} 
                                            height={250} 
                                            sizes='100vw'
                                            className='w-100 d-block rounded'
                                            style={{ filter: 'brightness(50%)' }}
                                        />
                                        <div style={{ position: 'absolute', top: '25%', color: 'white', padding: '20px' }}>
                                            <h5><b>SignatureCare Emergency Center - {location.name}</b></h5>
                                            <p>{location.street} {location.city}, {location.zip}</p>
                                        </div>
                                    </div>
                                </Link>
                            </div>
                        ))
                    }
                </div>
            </div>
        </>
    )
}

export const getStaticProps = async () => {
  try {
    const res = await http.get('/admin/locations');
    const data = res.data || [];
    const layoutData = await getLayoutData();
    const locations = data.filter(location => (location.name !== 'Greater Texas Division ' && location.status !== 2));

    return {
      props: {
        locations,
        layoutData
      },
      revalidate: 10,
    };
  } catch (err) {
    console.error('Error fetching locations:', err.message);
    return { notFound: true };
  }
};
