import Head from 'next/head';
import Image from 'next/image';
import Link from 'next/link';
import React from 'react'
import Swal from 'sweetalert2'
import withReactContent from 'sweetalert2-react-content'
import http from '../../components/utils/http';
import laravelURL from '../../components/utils/laravel-url';
import mainURL from '../../components/utils/main-url';
import { getLayoutData } from "../../components/utils/getLayoutData";

export default function LocationPage({ locations }) {
    const MySwal = withReactContent(Swal);

    return (
        <>
            <Head>
                <title>Emergency Room Locations</title>
                <meta name="description" content="SignatureCare Emergency Center 24-Hour Emergency Rooms in Texas - Houston, Austin, Odessa, Midland, Texarkana, College Station, Sugar Land, Stafford, etc" />
                <link rel="canonical" href={mainURL + "/locations"} />
                <meta property="og:locale" content="en_US" />
                <meta property="og:type" content="website" />
                <meta property="og:title" content="Locations Archive" />
                <meta property="og:url" content={mainURL + "/locations"} />
                <meta property="og:site_name" content="Emergency Room: SignatureCare Emergency Center 24-Hour ER" />
            </Head>

            <div className='bg-dark text-white mb-5'>
                <div className='container text-center'>
                    <h3 className='py-2'>Locations</h3>
                </div>
            </div>

            <section className="container">
                {locations?.map((location, index) => (
                    <div key={index} className='mb-5'>
                        <div className='row'>
                            <div className='col-md-3'>
                                <Image
                                    src={laravelURL + "/storage/" + location.img}
                                    alt={location.title}
                                    width="600" height="400" sizes="100vw"
                                    className="w-auto h-auto mb-4"
                                />
                            </div>
                            <div className='col-md-9'>
                                <Link href={'/locations/' + location.slug}>
                                    <h4 className='text-danger mb-3'>
                                        <b>{location.title}</b>
                                    </h4>
                                </Link>
                                <div className='ck-content'>
                                    <div dangerouslySetInnerHTML={{ __html: location.description.replace(/<[^>]+>/g, '').slice(0, 169) }} />
                                </div>
                            </div>
                        </div>
                        <div>
                            <div className='py-1 mt-3 border-top border-bottom'>
                                <small>
                                    By <span className='text-danger'>SignatureCare ER </span>
                                    {/* | {moment(location.date).format("MMMM Do, YYYY")}<i> </i> */}
                                </small>
                            </div>
                        </div>
                    </div>
                ))
                }
            </section>
        </>
    )
}

export const getStaticProps = async () => {
  try {
    const res = await http.get('/admin/sub-locations');
    const layoutData = await getLayoutData();
    return {
      props: {
        locations: res.data || [],
        layoutData
      },
      revalidate: 10,
    };
  } catch (err) {
    console.error('Error fetching sub-locations:', err.message);
    return { notFound: true };
  }
};
