import Head from 'next/head';
import Link from 'next/link';
import React from 'react';
import http from '../components/utils/http';
import mainURL from '../components/utils/main-url';
import BlogByCategory from './blog/categories/[category]';
import { getLayoutData } from "../components/utils/getLayoutData";

export default function ContactUs({ videos }) {
    let regex = /^.*(?:(?:youtu\.be\/|v\/|vi\/|u\/\w\/|embed\/|shorts\/)|(?:(?:watch)?\?v(?:i)?=|\&v(?:i)?=))([^#\&\?]*).*/;

    return (
        <>
            <Head>
                <title>Emergency Room News &amp; Videos: SignatureCare Emergency Center</title>
                <meta name="description" content="Latest emergency room news and videos from SignatureCare Emergency Center, 24-hour emergency rooms in Houston, Austin, Paris and other Texas cities." />
                <link rel="canonical" href={mainURL + "/news/"} />
                <meta property="og:locale" content="en_US" />
                <meta property="og:type" content="article" />
                <meta property="og:title" content="News & Videos" />
                <meta property="og:url" content={mainURL + "/news/"} />
                <meta property="og:site_name" content="Emergency Room: SignatureCare Emergency Center 24-Hour ER" />
                <meta property="article:publisher" content="https://www.facebook.com/SignatureCareER/" />
                <meta property="article:modified_time" content="2022-10-21T18:49:37+00:00" />
                <meta property="og:image" content="/assets/austin-er3.jpg" />
                <meta property="og:image:width" content={1000} />
                <meta property="og:image:height" content={609} />
                <meta property="og:image:type" content="image/jpeg" />
                <meta name="twitter:label1" content="Est. reading time" /><meta name="twitter:data1" content="13 minutes" />
            </Head>
            <section>
                <div className='text-center bg-dark text-white'>
                    <h4 className='py-2'>News &#38; Videos</h4>
                </div>
            </section>

            <br />
            <br />

            <section>
                <center>
                    <h4 className='text-danger'><b>SignatureCare Emergency Center Videos</b></h4>
                </center>
            </section>
            <br />

            <section>
                <center>
                    <div className='w-50'>
                        <hr className='curve' />
                    </div>
                </center>
            </section>

            <br />

            <section>
                <div className='container'>
                    <div className='row'>
                        {videos &&
                            videos.map((video, index) => (
                                <div className='col-md-4 mb-3' key={index}>
                                    <iframe width="100%" height={315}
                                        src={'https://www.youtube.com/embed/' + video.link.match(regex)[1]}>
                                    </iframe>
                                </div>
                            ))
                        }
                    </div>
                </div>
            </section>

            <section>
                <center>
                    <p>For additional videos, please go to our <Link href='https://www.youtube.com/channel/UCx4SjwyHoHNFY-BwP8f6EzQ/videos' className='text-danger'>YouTube Channel.</Link></p>
                    <hr className='curve w-50' />
                </center>
            </section>
            <br />
            <section>
                <center>
                    <h4 className='text-danger'><b>Emergency Room (ER) News</b></h4>
                    <hr className='curve w-50' />
                    <br />
                </center>
                <BlogByCategory newsVideos={true} />
            </section>

            <br />
            <br />
            <br />
        </>
    )
}

export const getStaticProps = async () => {
  try {
    const res = await http.get('/admin/videos');
    const layoutData = await getLayoutData();
    return {
      props: {
        videos: res.data || [],
        layoutData
      },
      revalidate: 10,
    };
  } catch (err) {
    console.error('Error fetching videos:', err.message);
    return { notFound: true };
  }
};
