import laravelURL from "../components/utils/laravel-url";
import mainURL from "../components/utils/main-url";

const EXTERNAL_DATA_URL = laravelURL + '/api/admin/next-paths';

function generateSiteMap(page, jobs) {
	return `<?xml version="1.0" encoding="UTF-8"?>
   <urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
     <!--We manually set some URLs we know already-->
     	<url>
	   		<loc>${mainURL}</loc>
	   	</url>
     	<url>
	   		<loc>${mainURL + '/join-our-team'}</loc>
	   	</url>
     	<url>
	   		<loc>${mainURL + '/join-our-team/online-application'}</loc>
	   	</url>
     	<url>
	   		<loc>${mainURL + '/blog'}</loc>
	   	</url>
     	<url>
	   		<loc>${mainURL + '/membership-login'}</loc>
	   	</url>
     	<url>
	   		<loc>${mainURL + '/membership-register'}</loc>
	   	</url>
     	<url>
	   		<loc>${mainURL + '/grade'}</loc>
	   	</url>
     	<url>
	   		<loc>${mainURL + '/locations'}</loc>
	   	</url>
       	<url>
	   		<loc>${mainURL + '/awards-recognition'}</loc>
	   	</url>
       	<url>
	   		<loc>${mainURL + '/closest-emergency-room'}</loc>
	   	</url>
       	<url>
	   		<loc>${mainURL + '/contact-us'}</loc>
	   	</url>
       	<url>
	   		<loc>${mainURL + '/emergency-room-appointment'}</loc>
	   	</url>
       	<url>
	   		<loc>${mainURL + '/investors'}</loc>
	   	</url>
       	<url>
	   		<loc>${mainURL + '/news'}</loc>
	   	</url>
       	<url>
	   		<loc>${mainURL + '/scholarship'}</loc>
	   	</url>
       	<url>
	   		<loc>${mainURL + '/search'}</loc>
	   	</url>
		${jobs.map((job) => {
		return `<url>
					<loc>${`${mainURL}/join-our-team/${job.slug}`}</loc>
				</url>`;
	}).join('')
		}
     	${page.map((slug) => {
			return `<url>
						<loc>${`${mainURL}/${slug}`}</loc>
					</url>`;
		}).join('')
		}
   	</urlset>
 	`;
}

function SiteMap() {
	// getServerSideProps will do the heavy lifting
}

export async function getServerSideProps({ res }) {
	// We make an API call to gather the URLs for our site
	const request = await fetch(EXTERNAL_DATA_URL);
	const page = await request.json();
	const job = await fetch(laravelURL + "/api/admin/job-posts");
	const jobs = await job.json();

	// We generate the XML sitemap with the posts data
	const sitemap = generateSiteMap(page, jobs);

	res.setHeader('Content-Type', 'text/xml');
	// we send the XML to the browser
	res.write(sitemap);
	res.end();

	return {
		props: {},
	};
}

export default SiteMap;